import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define the grid size
rows, cols = 5, 4

# Define colors for tiles and robots
white_paint_color = 'white'
black_paint_color = 'black'
unpainted_color = 'lightgreen'

# Define the tile goal status
goal_tile_status = {
    'tile_0-1': 'unpainted', 'tile_0-2': 'unpainted', 'tile_0-3': 'unpainted', 'tile_0-4': 'unpainted',
    'tile_1-1': 'white', 'tile_1-2': 'black', 'tile_1-3': 'white', 'tile_1-4': 'black',
    'tile_2-1': 'black', 'tile_2-2': 'white', 'tile_2-3': 'black', 'tile_2-4': 'white',
    'tile_3-1': 'white', 'tile_3-2': 'black', 'tile_3-3': 'white', 'tile_3-4': 'black',
    'tile_4-1': 'black', 'tile_4-2': 'white', 'tile_4-3': 'black', 'tile_4-4': 'white',
}

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        status = goal_tile_status[tile_id]
        if status == 'white':
            color = white_paint_color
        elif status == 'black':
            color = black_paint_color
        else:
            color = unpainted_color
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='black')

# Draw the robots at the bottom with no constraints
robot1_circle = patches.Circle((0.5, -1), 0.3, edgecolor='black', facecolor='white')
ax.add_patch(robot1_circle)
ax.text(0.5, -1.2, 'robot1\n(no constraints)', ha='center', va='center', fontsize=8, color='black')

robot2_circle = patches.Circle((1.5, -1), 0.3, edgecolor='black', facecolor='black')
ax.add_patch(robot2_circle)
ax.text(1.5, -1.2, 'robot2\n(no constraints)', ha='center', va='center', fontsize=8, color='white')

# Set limits and labels
ax.set_xlim(0, cols)
ax.set_ylim(-2, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=white_paint_color, edgecolor='black', label='Painted White'),
    patches.Patch(facecolor=black_paint_color, edgecolor='black', label='Painted Black'),
    patches.Patch(facecolor=unpainted_color, edgecolor='black', label='Unpainted Tile'),
    patches.Patch(facecolor='white', edgecolor='black', label='Robot1 (No constraints)'),
    patches.Patch(facecolor='black', edgecolor='black', label='Robot2 (No constraints)'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('tiles/one_shot/goal_diagram_code/attempts/goal_diagram_attempt_9.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# Robots are shown in the goal state, but they should not occupy any painted tiles.
